--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	"mental ray Arch and Design"
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3072 --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x70b05735L, 0x4a163654L) --Arch and Design Material
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	"Standard Material"
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3072 --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x2L, 0x0L) --Standard Material
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
--Should this be localized ?
fn AboutText =
(
	"Converts from a mental ray Arch and Design material to an Standard material"
)
--Internal function that does the parameter mapping
fn ConvertFrom_ArchAndDesignToStandard Source Dest =
(
	if ( false == VerifySource Source or 
		 false == VerifyDestination Dest
		) do
	(
		--Not the suitable nodes
		return undefined
	)

	Dest.twosided = not Source.opts_backface_cull
	
	--Diffuse
	Dest.diffuse = Source.diff_color
	if(Source.diff_color.controller != undefined) do Dest.diffuse.controller = Source.diff_color.controller
	Dest.diffuseMap = Source.diff_color_map
	Dest.diffuseMapAmount = Source.diff_weight * 100 
	Dest.diffuseMapEnable = Source.diff_color_map_on
	
	--Specular color
	Dest.specular = Source.refl_color
	if(Source.refl_color.controller != undefined) do Dest.specular.controller = Source.refl_color.controller
	Dest.specularMap = Source.refl_color_map 
	Dest.specularMapEnable = Source.refl_color_map_on
	Dest.specularMapAmount = Source.refl_weight * 100
	
	--specular level
	Dest.specularLevel = Source.refl_weight * 100
		
	--Glossiness
	Dest.glossiness = Source.refl_gloss * 100
	Dest.glossinessMap = Source.refl_gloss_map
	Dest.glossinessMapEnable = Source.refl_gloss_map_on
	
	--Bump
	Dest.bumpMap = Source.bump_map
	Dest.bumpMapEnable = Source.bump_map_on
	Dest.bumpMapAmount = Source.bump_map_amt * 100
	
	--Displacement
	Dest.displacementMap  = Source.displacement_map
	Dest.displacementMapEnable  = Source.displacement_map_on
	Dest.displacementMapAmount = Source.displacement_map_amt * 100

	--IOR
	Dest.ior = Source.refr_ior
	if(Source.refr_ior.controller != undefined) do Dest.ior.controller = Source.refr_ior.controller

	--Roughness
	Dest.diffuseRoughness = Source.diff_rough * 100 
	Dest.diffuseRoughnessMap = Source.diff_rough_map
	
	--Opaque
	Dest.opacity = (1.0 - Source.refr_weight) * 100
	
	--Self-illumination
	if(Source.self_illum_on) then
	(		
		Dest.useSelfIllumColor = on
		Dest.selfIllumColor = Source.self_illum_color_filter * Source.effectiveselfillum
		
		Dest.selfIllumMap = Source.self_illum_map
		Dest.selfIllumMapEnable = Source.self_illum_map_on		
	)
	else
	(
		Dest.useSelfIllumColor = off
		Dest.selfIllumAmount = 0
	)
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*Not use*/=
(
	--Create the dest material
	newMat = StandardMaterial shadertype:4
	
	--return the new created light node
	newMat

)

--Main entry point from this script
--This function handles the material's creation
fn Conversion archandDesignMat =
(
	if (false == VerifySource archandDesignMat )  do
	(
		--Not the suitable node
		return undefined
	)
	
	
	--Create the dest material
	newMat = StandardMaterial shadertype:4
	
	--Call the parameters mapping function to convert
	ConvertFrom_ArchAndDesignToStandard archandDesignMat newMat
	
	if (IsProperty archandDesignMat "name") and (undefined != archandDesignMat.name) and (String == classof archandDesignMat.name)  and (IsProperty newMat "name") do
	(
		newMat.name = archandDesignMat.name
	)
	
	--return the new created light node
	newMat
)
